#!/bin/bash
usage=$'Usage: multicast-test.sh <IP-addr-of-hostA> <IP-addr-of-hostB> <IP-addr-of-hostC>'
if [ $# != 3 ]
then
    echo "$usage"
    exit
fi
a_ipaddr=$1
b_ipaddr=$2
c_ipaddr=$3
echo "host A IP address $a_ipaddr"
echo "host B IP address $b_ipaddr"
echo "host C IP address $c_ipaddr"
if [ ! -d logs ]
then
    mkdir logs
fi
workdir=$(pwd)

clean_up() {
    echo "cleaning up..."
    ssh $b_ipaddr "sudo killall ndn-traffic-server; sudo killall nfd"
    ssh $c_ipaddr "sudo killall ndn-traffic-server; sudo killall nfd"
    sudo killall nfd
}

# start nfd and ndn-traffic-server on B and C
echo "starting nfd and ndn-traffic-server on B and C..."
ssh $b_ipaddr "if [ ! -d $(pwd)/logs ]; then mkdir $(pwd)/logs; fi"
ssh $b_ipaddr "sudo nfd > $workdir/logs/nfd.log 2>&1 & sleep 3; ndn-traffic-server $workdir/NDNTrafficServerB.conf > $workdir/logs/server.log 2>&1 &"
ssh $c_ipaddr "if [ ! -d $(pwd)/logs ]; then mkdir $(pwd)/logs; fi"
ssh $c_ipaddr "sudo nfd > $workdir/logs/nfd.log 2>&1 & sleep 3; ndn-traffic-server $workdir/NDNTrafficServerC.conf > $workdir/logs/server.log 2>&1 &"

# start nfd and add nexthop of ndn:/test-mcast to UDP multicast face
echo "starting nfd and adding nexthop of ndn:/test-mcast to UDP multicast face..."
sudo nfd > $workdir/logs/nfd.log 2>&1 &
sleep 3
faceid=$(nfd-status -f | grep $a_ipaddr | grep -Po 'faceid=.*? ' | sed 's/faceid=//' | sed 's/ //')
nfdc add-nexthop ndn:/test-mcast $faceid
nfdc set-strategy ndn:/test-mcast ndn:/localhost/nfd/strategy/broadcast

# use ndn-tlv-peek to test multicast feature
echo "using ndn-tlv-peek to test multicast feature..."
response=$(ndn-tlv-peek -p ndn:/test-mcast/B/1)
if [[ $response != 'AAAAAAAA' ]]
then
    echo "FAIL: Expected data for ndn:/test-mcast/B/1 is: 'AAAAAAAA', Actual: '$response'"
    clean_up
    exit 1
fi
response=$(ndn-tlv-peek -p ndn:/test-mcast/C/1)
if [[ $response != 'AAAAAAAA' ]]
then
    echo "FAIL: Expected data for ndn:/test-mcast/C/1 is: 'AAAAAAAA', Actual: '$response'"
    clean_up
    exit 1
fi
response=$(ndn-tlv-peek -p ndn:/test-mcast/Z/1)
if [[ $response != 'BBBBBBBB' ]]
then
    echo "FAIL: Expected data for ndn:/test-mcast/Z/1 is: 'BBBBBBBB', Actual: '$response'"
    clean_up
    exit 1
fi

# kill ndn-traffic-server on host B
echo "killing ndn-traffic-server on host B..."
ssh $b_ipaddr "sudo killall ndn-traffic-server"

# use ndn-tlv-peek to request ndn:/testmcast/Z/2
echo "using ndn-tlv-peek to request ndn:/testmcast/Z/2..."
response=$(ndn-tlv-peek -p ndn:/test-mcast/Z/2)
if [[ $response != 'BBBBBBBB' ]]
then
    echo "FAIL: Expected data for ndn:/test-mcast/Z/2 is: 'BBBBBBBB', Actual: '$response'"
    clean_up
    exit 1
fi

# clean up
clean_up
echo "Multicast Test PASSED"
