/* -*- Mode:C++; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/**
 * Copyright (c) 2013-2014 Regents of the University of California.
 *
 * This file is part of ndn-cxx library (NDN C++ library with eXperimental eXtensions).
 *
 * ndn-cxx library is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * ndn-cxx library is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received copies of the GNU General Public License and GNU Lesser
 * General Public License along with ndn-cxx, e.g., in COPYING.md file.  If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * See AUTHORS.md for complete list of ndn-cxx authors and contributors.
 *
 * @author Wentao Shang <http://irl.cs.ucla.edu/~wentao/>
 */

#include "face.hpp"
#include "security/key-chain.hpp"
#include "common.hpp"

namespace ndn {

class Producer
{
    shared_ptr<Data> data;
    uint8_t *buf;
    int segnum = 0;
    int max_segnumber;
    int buf_size;

public:
  Producer(const char* name, int size, int num_segments)
    : m_name(name)
  {
    buf_size = size;
    max_segnumber = num_segments;
    buf = new uint8_t[size];
    memset(buf, 'A', size);
    buf[size-1] = 0;


    //shared_ptr<Data> data = make_shared<Data>(Name(m_name).appendSegment(segnum));
    
    for(segnum=0; segnum<max_segnumber; segnum++)
      {
        data = make_shared<Data>(Name(m_name).appendSegment(segnum));
        data->setFreshnessPeriod(time::milliseconds(10000)); // 10 sec
        data->setContent(reinterpret_cast<const uint8_t*>(buf), size);
        if (segnum == max_segnumber-1)
           data->setFinalBlockId(data->getName()[-1]);
        m_keychain.sign(*data);

        Block encoded = data->wireEncode();
        std::cerr << data->getName() << " size: " << encoded.value_size() << "\n";
        m_face.put(*data);
      }
  }

  void
  onInterest(const Interest& interest)
  {
      std::cerr << "Received Interest" << interest.getName() << "buf size" << buf_size;
  /*    
      data = make_shared<Data>(Name(interest.getName()));
      data->setFreshnessPeriod(time::milliseconds(10000)); // 10 sec
        data->setContent(reinterpret_cast<const uint8_t*>(buf), buf_size);
        if (segnum == max_segnumber-1)
           data->setFinalBlockId(data->getName()[-1]);
        m_keychain.sign(*data);

  //      Block encoded = data->wireEncode();
  //      std::cerr << data->getName() << " size: " << encoded.value_size() << "\n";
        m_face.put(*data);
   

            //Block encoded = data->wireEncode();
    //size_t segnum = static_cast<size_t>(interest.getName().rbegin()->toSegment());
    //
    //if (segnum < m_store.size())
//    m_face.put(*m_store[segnum]);
//    m_face.put(*data);
     //
     */
  }

  void
  onRegisterFailed(const Name& prefix, const std::string& reason)
  {
    std::cerr << "ERROR: Failed to register prefix '"
              << prefix << "' in local hub's daemon (" << reason << ")"
              << std::endl;
    m_face.shutdown();
  }

  void
  run()
  {
     m_face.setInterestFilter(m_name,
                              bind(&Producer::onInterest, this, _2),
                              RegisterPrefixSuccessCallback(),
                              bind(&Producer::onRegisterFailed, this, _1, _2));
    m_face.processEvents();
  }

private:
  Name m_name;
  Face m_face;
  KeyChain m_keychain;

  std::vector< shared_ptr<Data> > m_store;
//  std::vector< shared_ptr<Data> > data;
//    shared_ptr<Data> data = make_shared<Data>(Name(m_name).appendSegment(segnum));
};

int
main(int argc, char** argv)
{
  if (argc < 4)
    {
      std::cerr << "Usage: ./ndnputbigchunk data_prefix size number_of_segments\n";
      return -1;
    }

  time::steady_clock::TimePoint startTime = time::steady_clock::now();

  std::cerr << "Preparing the input..." << std::endl;
  Producer producer(argv[1], atoi(argv[2]), atoi(argv[3]));
  std::cerr << "Ready... (took " << (time::steady_clock::now() - startTime) << ")\n";

  producer.run();
  return 0;
}

} // namespace ndn

int
main(int argc, char** argv)
{
  return ndn::main(argc, argv);
}
