#include <ndn-cxx/util/io.hpp>
#include <ndn-cxx/face.hpp>
#include <ndn-cxx/security/key-chain.hpp>

namespace ndn {

class Producer : noncopyable
{
public:
 void
 run()
 {
   m_face.setInterestFilter("/NTORRENT/foo/bar.txt/%FE%00/%FE%00/sha256digest=f4446686f2c9fd94d0d24b26eae465600547c1b37afdfca6abf026849dad0cda",
                            bind(&Producer::onInterest, this, _1, _2),
                            RegisterPrefixSuccessCallback(),
                            bind(&Producer::onRegisterFailed, this, _1, _2));
   m_face.processEvents();
 }

private:
 void
 onInterest(const InterestFilter& filter, const Interest& interest)
 {
   std::cout << "<< I: " << interest << std::endl;
   auto data = io::load<Data>("data.txt");
   std::cout << ">> D: " << *data << std::endl;
   m_face.put(*data);
 }


 void
 onRegisterFailed(const Name& prefix, const std::string& reason)
 {
   std::cerr << "ERROR: Failed to register prefix \""
             << prefix << "\" in local hub's daemon (" << reason << ")"
             << std::endl;
   m_face.shutdown();
 }

private:
 Face m_face;
 KeyChain m_keyChain;
};

} // namespace ndn

int
main(int argc, char** argv)
{
 ndn::Producer producer;
 try {
   producer.run();
 }
 catch (const std::exception& e) {
   std::cerr << "ERROR: " << e.what() << std::endl;
 }
 return 0;
}