#include <ndn-cxx/mgmt/dispatcher.hpp>
#include <ndn-cxx/face.hpp>
#include <ndn-cxx/security/key-chain.hpp>

#include <iostream>
#include <unistd.h>

using namespace std;
using namespace ndn;

int main(int argc, char** argv) {
  if ( argc != 3 ) {
    std::cout << " Usage: " << argv[0]
              << " <repoName> <number>\n";
  }

  Face face;
  KeyChain keyChain;
  mgmt::Dispatcher m_dispatcher(face, keyChain);

  ndn::mgmt::PostNotification m_postNotification;

  m_postNotification = m_dispatcher.addNotificationStream("insert");

  // Listen on /localhost/reponame
  ndn::Name topLevelPrefix("localhost");
  topLevelPrefix.append("datastream");
  topLevelPrefix.append(Name(argv[1]));
  cout << "Dispatcher top level prefix: " << topLevelPrefix << endl;
  m_dispatcher.addTopPrefix(topLevelPrefix);

  face.setInterestFilter(Name("/example/testApp/").append(argv[2]),
                         [&] (const InterestFilter& filter, const Interest& interest) {
                           std::cout << "Received interest " << interest << std::endl;
                           for (int i = 0; i < 1; i++) {
                            Data data(Name("/test/").append(argv[1]).appendNumber(i));
                            data.setFreshnessPeriod(time::milliseconds(1000));
                            keyChain.sign(data);
                             m_postNotification(data.wireEncode());
                           }
                         },
                         nullptr,
                         nullptr);


  face.processEvents();

  return 0;
}
