from mininet.log import setLogLevel, info
from mn_wifi.topo import Topo
from minindn.minindn import Minindn
from minindn.wifi.minindnwifi import MinindnWifi
from minindn.apps.app_manager import AppManager
from minindn.util import MiniNDNCLI, getPopen
from minindn.apps.nfd import Nfd
from minindn.apps.nlsr import Nlsr
from minindn.helpers.nfdc import Nfdc
from subprocess import STDOUT

PREFIX = "/example"

def run():
    topo = Topo()
    # Setup topo
    print("Setup")
    a = topo.addStation('a')
    b = topo.addHost('b')
    ap = topo.addAccessPoint('ap1')
    topo.addLink(a, ap, delay='10ms', bw=10)
    topo.addLink(b, ap, delay='10ms', bw=10, wired=True)
    ndn = MinindnWifi(topo=topo)
    ndn.start()
    quick_hack_for_params_issue(ndn.net["b"])
    nodes = [ndn.net["a"], ndn.net["b"]]
    nfds = AppManager(ndn, nodes, Nfd, logLevel="DEBUG")
    #nlsr = AppManager(ndn, nodes, Nlsr, logLevel="DEBUG")
    # This is a fancy way of setting up the routes without violating DRY;
    # the important bit to note is the Nfdc command
    links = {"a":["b"]}
    for first in links:
        for second in links[first]:
            host1 = ndn.net[first]
            host2 = ndn.net[second]
            interface = host2.connectionsTo(ndn.net["ap1"])[0][0]
            #print(interface)
            interface_ip = interface.IP()
            Nfdc.createFace(host1, interface_ip)
            Nfdc.registerRoute(host1, PREFIX, interface_ip, cost=0)
    MiniNDNCLI(ndn.net)

# Note: Delete this if Gerrit mini-ndn change 6375 gets merged
def quick_hack_for_params_issue(host):
    host.params['params'] = {}
    host.params['params']['workDir'] = Minindn.workDir
    homeDir = "{}/{}".format(Minindn.workDir, host.name)
    host.params['params']['homeDir'] = homeDir
    host.cmd("mkdir -p {}".format(homeDir))
    host.cmd('export HOME={} && cd ~'.format(homeDir))

if __name__ == '__main__':
    run()