/* -*- Mode:C++; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/**
 * Copyright (c) 2013-2015 Regents of the University of California.
 *
 * This file is part of ndn-cxx library (NDN C++ library with eXperimental eXtensions).
 *
 * ndn-cxx library is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * ndn-cxx library is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received copies of the GNU General Public License and GNU Lesser
 * General Public License along with ndn-cxx, e.g., in COPYING.md file.  If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * See AUTHORS.md for complete list of ndn-cxx authors and contributors.
 *
 * @author Alexander Afanasyev <http://lasr.cs.ucla.edu/afanasyev/index.html>
 */

// correct way to include ndn-cxx headers

#include "face.hpp"
#include "security/key-chain.hpp"
#include "data.hpp"
#include "link.hpp"
#include "common.hpp"
#include "util/io.hpp"

namespace ndn {
// Additional nested namespace could be used to prevent/limit name contentions
namespace examples {

  class LinkGenerator : noncopyable
{
public:
  void
  run()
  {
    //Link link1("test", {{10, "/test1"}, {20, "/test2"}, {100, "/test3"}});

    Link link1("/A/B/LINK", {{100, "/UA/A/B"},{10,"/ASU/A/B"}});

    KeyChain keyChain;
    keyChain.sign(link1);
    Block wire = link1.wireEncode();
    io::save(link1, "tmp-link.txt");

    std::cout<<link1.getName().toUri()<<"\n";
  }

};

}
}

int
main(int argc, char** argv)
{
  ndn::examples::LinkGenerator linkGenerator;
  try {
    linkGenerator.run();
  }
  catch (const std::exception& e) {
    std::cerr << "ERROR: " << e.what() << std::endl;
  }
  return 0;

  return 0;
}
