from time import sleep
from ndnwifi import WifiExperimentManager
from wifiexperiment import wifiExperiment
import re
# Note: this is not deterministically failing and will work sometimes, but it WILL tell you when it crashes fairly reliably
class exampleExp(wifiExperiment):
    def __init__(self, args):
        self.net = args["net"]
        self.route = "/routetonowhere"

    def start(self):
        sleep(1)
        for sta in self.net.stations:
            print(sta.name)
            face_output = sta.cmd("nfdc face")
            multicast_face = re.search("(?<=faceid=)[0-9]+(?= remote=udp4://224)", face_output)
            if not multicast_face:
                raise Exception("No multicast face found")
            print("Multicast face found")
            sta.cmd("nfdc route add {} {}".format(self.route, multicast_face.group(0)))

    @staticmethod
    def register(name, experimentClass):
        WifiExperimentManager.register(name, experimentClass)

wifiExperiment.register('example', exampleExp)
