#!/usr/bin/env bash
identity=/remote/test
log=test.log

usage() {
    echo "usage: sh laptop.sh server_ip"
    exit 1
}

[ $# -gt 0 ] || usage
echo "server ip is $1!" && server_ip=$1

[ $(ndnsec-list | grep -c -e $identity$) -gt 0 ] || ndnsec-key-gen -n $identity | ndnsec-cert-install -
pid=$(pgrep -x nfd) && [ "$pid"x != x ] && sudo killall nfd

echo "start NFD" && sudo nfd --config laptop.nfd.conf >$log 2>&1 &

sleep 2 && echo "register /localhop/nfd" && nfdc register /localhop/nfd udp4://$server_ip

echo "start ndnpingserver" && ndnpingserver $identity >>$log 2>&1 &
sleep 2 && echo "end ndnpingserver" && sudo killall ndnpingserver
